package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcPerCampaignAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

public class StrategyAverageCpcPerCampaignAddMap extends ModelBeanMap<StrategyAverageCpcPerCampaignAddMap> {

    public static final String AVERAGE_CPC = "averageCpc";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String BID_CEILING = "bidCeiling";

    public StrategyAverageCpcPerCampaignAddMap() {
        super();
        setBean(new StrategyAverageCpcPerCampaignAdd());
    }

    public StrategyAverageCpcPerCampaignAddMap(StrategyAverageCpcPerCampaignAdd strategyAverageCpcPerCampaignAdd) {
        super();
        setBean(strategyAverageCpcPerCampaignAdd);
    }

    public StrategyAverageCpcPerCampaignAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageCpcPerCampaignAddMap defaultStrategyAverageCpcPerCampaignAdd(Currency currency) {
        Money averagePrice = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withAverageCpc(averagePrice.bidLong().longValue())
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpcPerCampaignAddMap withAverageCpc(Long averageCpc) {
        this.put(AVERAGE_CPC, averageCpc);
        return this;
    }

    public StrategyAverageCpcPerCampaignAddMap withBidCeiling(Long bidCeiling) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpcPerCampaignBidCeiling(bidCeiling);
        this.put(BID_CEILING, jaxbElement);
        return this;
    }

    public StrategyAverageCpcPerCampaignAddMap withWeeklySpendLimit(Long weeklyLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpcWeeklySpendLimit(weeklyLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }
}
