package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcPerFilter;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

public class StrategyAverageCpcPerFilterMap extends ModelBeanMap<StrategyAverageCpcPerFilterMap> {

    public static final String FILTER_AVERAGE_CPC = "filterAverageCpc";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String BID_CEILING = "bidCeiling";

    public StrategyAverageCpcPerFilterMap() {
        super();
        setBean(new StrategyAverageCpcPerFilter());
    }

    public StrategyAverageCpcPerFilterMap(StrategyAverageCpcPerFilter strategyAverageCpcPerFilter) {
        super();
        setBean(strategyAverageCpcPerFilter);
    }

    public StrategyAverageCpcPerFilterMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageCpcPerFilterMap defaultStrategyAverageCpcPerFilter(Currency currency) {
        Money averagePrice = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withFilterAverageCpc(averagePrice.bidLong().longValue())
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpcPerFilterMap withFilterAverageCpc(Long averageCpc) {
        this.put(FILTER_AVERAGE_CPC, averageCpc);
        return this;
    }

    public StrategyAverageCpcPerFilterMap withBidCeiling(Long bidCeiling) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpcPerCampaignBidCeiling(bidCeiling);
        this.put(BID_CEILING, jaxbElement);
        return this;
    }

    public StrategyAverageCpcPerFilterMap withWeeklySpendLimit(Long weeklyLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpcWeeklySpendLimit(weeklyLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }
}
