package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyAverageCpiAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pavryabov on 24.09.15.
 */
public class StrategyAverageCpiAddMap extends ModelBeanMap<StrategyAverageCpiAddMap> {

    public static final String AVERAGE_CPI = "averageCpi";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public StrategyAverageCpiAddMap() {
        super();
        setBean(new StrategyAverageCpiAdd());
    }

    public StrategyAverageCpiAddMap(StrategyAverageCpiAdd strategyAverageCpiAdd) {
        super();
        setBean(strategyAverageCpiAdd);
    }

    public StrategyAverageCpiAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageCpiAddMap defaultStrategyAverageCpi(Currency currency) {
        Money averagePrice = MoneyCurrency.get(currency).getMinAveragePrice();
        return this.withAverageCpi(averagePrice.bidLong().longValue());
    }

    public StrategyAverageCpiAddMap withBidCeiling(Long bidCeiling) {
        this.put(BID_CEILING, bidCeiling);
        return this;
    }

    public StrategyAverageCpiAddMap withAverageCpi(Long averageCpi) {
        this.put(AVERAGE_CPI, averageCpi);
        return this;
    }

    public StrategyAverageCpiAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        this.put(WEEKLY_SPEND_LIMIT, weeklySpendLimit);
        return this;
    }
}
