package ru.yandex.autotests.directapi.model.api5.campaigns;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class StrategyAverageCpvBaseMap<T> extends ModelBeanMap<StrategyAverageCpvBaseMap> {

    public static final String AVERAGE_CPV = "averageCpv";
    public static final String SPEND_LIMIT = "spendLimit";

    public StrategyAverageCpvBaseMap() {
        super();
    }

    public T withAverageCpv(Long averageCpv) {
        this.put(AVERAGE_CPV, averageCpv);
        return (T) this;
    }

    public T withSpendLimit(Long SpendLimit) {
        this.put(SPEND_LIMIT, SpendLimit);
        return (T) this;
    }

    public T withDefaultAverageCpv(Long averageCpv, Long spendLimit) {
        this.put(AVERAGE_CPV, averageCpv);
        this.put(SPEND_LIMIT, spendLimit);
        return (T) this;
    }
}
