package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyAverageCrrAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class StrategyAverageCrrAddMap extends ModelBeanMap<StrategyAverageCrrAddMap> {

    public static final String GOAL_ID = "goalId";
    public static final String CRR = "crr";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public static final Integer DEFAULT_CRR = 100;
    public static final Long DEFAULT_WEEKLY_SPEND_LIMIT = 500_000_000L;
    public static final Integer MIN_CRR = 1;
    public static final Integer MAX_CRR = 500;

    public StrategyAverageCrrAddMap() {
        super();
        setBean(new StrategyAverageCrrAdd());
    }

    public StrategyAverageCrrAddMap(StrategyAverageCrrAdd strategyAverageCrrAdd) {
        super();
        setBean(strategyAverageCrrAdd);
    }

    @Override
    public StrategyAverageCrrAddMap put(Object name, Object value) {
        super.put(name, value);
        return this;
    }

    public StrategyAverageCrrAddMap withGoalId(Long goalId) {
        return this.put(GOAL_ID, goalId);
    }

    public StrategyAverageCrrAddMap withCrr(Integer crr) {
        return this.put(CRR, crr);
    }

    public StrategyAverageCrrAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        return this.put(WEEKLY_SPEND_LIMIT, weeklySpendLimit);
    }

    public StrategyAverageCrrAddMap defaultStrategyAverageCrr() {
        return this.withCrr(DEFAULT_CRR)
                .withWeeklySpendLimit(DEFAULT_WEEKLY_SPEND_LIMIT);
    }

}