package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCrr;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class StrategyAverageCrrMap extends ModelBeanMap<StrategyAverageCrrMap> {

    public static final String GOAL_ID = "goalId";
    public static final String CRR = "crr";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public static final Integer DEFAULT_CRR = 100;

    public StrategyAverageCrrMap() {
        super();
        this.setBean(new StrategyAverageCrr());
    }
    
    public StrategyAverageCrrMap(StrategyAverageCrr strategyAverageCrr) {
        super();
        this.setBean(strategyAverageCrr);
    }

    public StrategyAverageCrrMap defaultStrategyAverageCrr() {
        return this.withCrr(DEFAULT_CRR);
    }

    @Override
    public StrategyAverageCrrMap put(Object name, Object value) {
        super.put(name, value);
        return this;
    }

    public StrategyAverageCrrMap withCrr(Integer crr) {
        return this.put(CRR, crr);
    }

    public StrategyAverageCrrMap withGoalId(Long goalId) {
        return this.put(GOAL_ID, goalId);
    }

    public StrategyAverageCrrMap withWeeklySpendLimit(Long weeklySpendLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyPayForConversionWeeklySpendLimit(weeklySpendLimit);
        return this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
    }
}
