package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyAverageRoiAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 01.09.15.
 */
public class StrategyAverageRoiAddMap extends ModelBeanMap<StrategyAverageRoiAddMap> {

    public static final String RESERVE_RETURN = "reserveReturn";
    public static final String ROI_COEF = "roiCoef";
    public static final String GOAL_ID = "goalId";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String PROFITABILITY = "profitability";

    public static final Long MIN_PROFITABILITY = 0L; //0
    public static final Long MAX_PROFITABILITY = 100000000L; //100
    public static final Integer MIN_RESERVE_RETURN = 0;
    public static final Integer MAX_RESERVE_RETURN = 100;
    public static final Long MIN_ROI_COEF = -990000L; //-0.99

    public static final Long DEFAULT_PROFITABILITY = 2000000L;
    public static final Integer DEFAULT_RESERVE_RETURN = 10;
    public static final Long DEFAULT_ROI_COEF = 1000000L;

    public static final Long MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID = 13L;

    public StrategyAverageRoiAddMap() {
        super();
        setBean(new StrategyAverageRoiAdd());
    }

    public StrategyAverageRoiAddMap(StrategyAverageRoiAdd strategyAverageRoiAdd) {
        super();
        setBean(strategyAverageRoiAdd);
    }

    public StrategyAverageRoiAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageRoiAddMap defaultStrategyAverageRoi() {
        return this.withReserveReturn(DEFAULT_RESERVE_RETURN)
                .withRoiCoef(DEFAULT_ROI_COEF);
    }

    public StrategyAverageRoiAddMap withReserveReturn(Integer reserveReturn) {
        this.put(RESERVE_RETURN, reserveReturn);
        return this;
    }

    public StrategyAverageRoiAddMap withRoiCoef(Long roiCoef) {
        this.put(ROI_COEF, roiCoef);
        return this;
    }

    public StrategyAverageRoiAddMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }

    public StrategyAverageRoiAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        this.put(WEEKLY_SPEND_LIMIT, weeklySpendLimit);
        return this;
    }

    public StrategyAverageRoiAddMap withBidCeiling(Long bidCeiling) {
        this.put(BID_CEILING, bidCeiling);
        return this;
    }

    public StrategyAverageRoiAddMap withProfitability(Long profitability) {
        this.put(PROFITABILITY, profitability);
        return this;
    }
}
