package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyCpAverageCpvAdd;
import com.yandex.direct.api.v5.general.YesNoEnum;

public class StrategyCpAverageCpvAddMap extends StrategyAverageCpvAddBaseMap<StrategyCpAverageCpvAddMap> {

    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String AUTO_CONTINUE = "autoContinue";

    public StrategyCpAverageCpvAddMap() {
        super();
        setBean(new StrategyCpAverageCpvAdd());
    }

    public StrategyCpAverageCpvAddMap(StrategyCpAverageCpvAdd strategyCpAverageCpvAdd) {
        super();
        setBean(strategyCpAverageCpvAdd);
    }

    public StrategyCpAverageCpvAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyCpAverageCpvAddMap withStartDate(String startDate) {
        this.put(START_DATE, startDate);
        return this;
    }

    public StrategyCpAverageCpvAddMap withEndDate(String endDate) {
        this.put(END_DATE, endDate);
        return this;
    }

    public StrategyCpAverageCpvAddMap withAutoContinue(YesNoEnum autoContinue) {
        this.put(AUTO_CONTINUE, autoContinue);
        return this;
    }
}
