package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyCpAverageCpv;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.joda.time.DateTime;

public class StrategyCpAverageCpvMap extends StrategyAverageCpvBaseMap<StrategyCpAverageCpvMap> {

    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String AUTO_CONTINUE = "autoContinue";

    public static final String DATE_PATTERN = "yyyy-MM-dd";

    public StrategyCpAverageCpvMap() {
        super();
        setBean(new StrategyCpAverageCpv());
    }

    public StrategyCpAverageCpvMap(StrategyCpAverageCpv strategyCpAverageCpv) {
        super();
        setBean(strategyCpAverageCpv);
    }

    public StrategyCpAverageCpvMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyCpAverageCpvMap withStartDate(String startDate) {
        this.put(START_DATE, startDate);
        return this;
    }

    public StrategyCpAverageCpvMap withEndDate(String endDate) {
        this.put(END_DATE, endDate);
        return this;
    }

    public StrategyCpAverageCpvMap withAutoContinue(YesNoEnum autoContinue) {
        this.put(AUTO_CONTINUE, autoContinue);
        return this;
    }

    public StrategyCpAverageCpvMap withDefaultCpAverageCpv(Long averageCpv, Long spendLimit) {
        this.withDefaultAverageCpv(averageCpv, spendLimit);
        this.put(START_DATE, DateTime.now().toString(DATE_PATTERN));
        this.put(END_DATE, DateTime.now().plusDays(1).toString(DATE_PATTERN));
        this.put(AUTO_CONTINUE, YesNoEnum.NO);
        return this;
    }
}
