package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyCpDecreasedPriceForRepeatedImpressions;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.joda.time.DateTime;

/**
 * Created by gerdler on 08.09.18.
 */
public class StrategyCpDecreasedPriceForRepeatedImpressionsMap extends StrategyDecreasedPriceForRepeatedImpressionsBaseMap<StrategyCpDecreasedPriceForRepeatedImpressionsMap> {

    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String AUTO_CONTINUE = "autoContinue";

    public static final String DATE_PATTERN = "yyyy-MM-dd";

    public StrategyCpDecreasedPriceForRepeatedImpressionsMap() {
        super();
        setBean(new StrategyCpDecreasedPriceForRepeatedImpressions());
    }

    public StrategyCpDecreasedPriceForRepeatedImpressionsMap(StrategyCpDecreasedPriceForRepeatedImpressions strategyCpDecreasedPriceForRepeatedImpressions) {
        super();
        setBean(strategyCpDecreasedPriceForRepeatedImpressions);
    }

    public StrategyCpDecreasedPriceForRepeatedImpressionsMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyCpDecreasedPriceForRepeatedImpressionsMap withStartDate(String startDate) {
        this.put(START_DATE, startDate);
        return this;
    }

    public StrategyCpDecreasedPriceForRepeatedImpressionsMap withEndDate(String endDate) {
        this.put(END_DATE, endDate);
        return this;
    }

    public StrategyCpDecreasedPriceForRepeatedImpressionsMap withAutoContinue(YesNoEnum autoContinue) {
        this.put(AUTO_CONTINUE, autoContinue);
        return this;
    }

    public StrategyCpDecreasedPriceForRepeatedImpressionsMap withDefaultCpDecreasedPriceForRepeatedImpressions(Long averageCpm, Long spendLimit) {
        this.withDefaultDecreasedPriceForRepeatedImpressions(averageCpm, spendLimit);
        this.put(START_DATE, DateTime.now().toString(DATE_PATTERN));
        this.put(END_DATE, DateTime.now().plusDays(1).toString(DATE_PATTERN));
        this.put(AUTO_CONTINUE, YesNoEnum.NO);
        return this;
    }
}
