package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyMaximumAppInstalls;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pavryabov on 19.10.15.
 */
public class StrategyMaximumAppInstallsMap extends StrategyWeeklyBudgetBaseMap<StrategyMaximumAppInstallsMap> {

    public StrategyMaximumAppInstallsMap() {
        super();
        setBean(new StrategyMaximumAppInstalls());
    }

    public StrategyMaximumAppInstallsMap(StrategyMaximumAppInstalls strategyMaximumAppInstalls) {
        super();
        setBean(strategyMaximumAppInstalls);
    }

    public StrategyMaximumAppInstallsMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyMaximumAppInstallsMap defaultStrategyMaximumAppInstalls(Currency currency) {
        Money weeklyBudget = MoneyCurrency.get(currency).getMinWeeklyBudgetAmount();
        return this
                .withWeeklySpendLimit(weeklyBudget.bidLong().longValue())
                .withBidCeiling(null);
    }
}
