package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyMaximumClicksAdd;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pavryabov on 05.08.15.
 */
public class StrategyMaximumClicksAddMap extends StrategyWeeklyBudgetAddBaseMap<StrategyMaximumClicksAddMap> {

    public StrategyMaximumClicksAddMap() {
        super();
        setBean(new StrategyMaximumClicksAdd());
    }

    public StrategyMaximumClicksAddMap(StrategyMaximumClicksAdd strategyMaximumClicksAdd) {
        super();
        setBean(strategyMaximumClicksAdd);
    }

    public StrategyMaximumClicksAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyMaximumClicksAddMap defaultStrategyMaximumClicks(Currency currency) {
        Money weeklyBudget = MoneyCurrency.get(currency).getMinWeeklyBudgetAmount();
        return this.withWeeklySpendLimit(weeklyBudget.bidLong().longValue());
    }
}
