package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyMaximumClicks;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pavryabov on 19.10.15.
 */
public class StrategyMaximumClicksMap extends StrategyWeeklyBudgetBaseMap<StrategyMaximumClicksMap> {

    public StrategyMaximumClicksMap() {
        super();
        setBean(new StrategyMaximumClicks());
    }

    public StrategyMaximumClicksMap(StrategyMaximumClicks strategyMaximumClicks) {
        super();
        setBean(strategyMaximumClicks);
    }

    public StrategyMaximumClicksMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyMaximumClicksMap defaultStrategyMaximumClicks(Currency currency) {
        Money weeklyBudget = MoneyCurrency.get(currency).getMinWeeklyBudgetAmount();
        return this
                .withWeeklySpendLimit(weeklyBudget.bidLong().longValue())
                .withBidCeiling(null);
    }
}
