package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyNetworkDefault;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 19.10.15.
 */
public class StrategyNetworkDefaultMap extends ModelBeanMap<StrategyNetworkDefaultMap> {
    public static final String LIMIT_PERCENT = "limitPercent"; //old ContextLimitSum

    public static final Integer TEST_LIMIT_PERCENT = 30;

    public static final Integer DEFAULT_LIMIT_PERCENT = 100;

    public StrategyNetworkDefaultMap() {
        super();
        setBean(new StrategyNetworkDefault());
    }

    public StrategyNetworkDefaultMap(StrategyNetworkDefault networkDefaultParams) {
        super();
        setBean(networkDefaultParams);
    }

    public StrategyNetworkDefaultMap defaultStrategyNetworkDefault() {
        return this.withLimitPercent(TEST_LIMIT_PERCENT);
    }

    public StrategyNetworkDefaultMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyNetworkDefaultMap withLimitPercent(Integer limitPercent) {
        this.put(LIMIT_PERCENT, limitPercent);
        return this;
    }
}
