package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaAdd;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pashkus on 25.05.20.
 */
public class StrategyPayForConversionAddMap extends ModelBeanMap<StrategyPayForConversionAddMap> {

    public static final String CPA = "cpa";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String GOAL_ID = "goalId";

    public StrategyPayForConversionAddMap() {
        super();
        setBean(new StrategyPayForConversionAdd());
    }

    public StrategyPayForConversionAddMap(StrategyPayForConversionAdd strategyPayForConversionAdd) {
        super();
        setBean(strategyPayForConversionAdd);
    }

    public StrategyPayForConversionAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyPayForConversionAddMap defaultStrategyPayForConversion(Currency currency) {
        Money minCpa = MoneyCurrency.get(currency).getMinAveragePrice();
        return this.withCpa(minCpa.bidLong().longValue());
    }

    public StrategyPayForConversionAddMap withCpa(Long cpa) {
        this.put(CPA, cpa);
        return this;
    }

    public StrategyPayForConversionAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        this.put(WEEKLY_SPEND_LIMIT, weeklySpendLimit);
        return this;
    }

    public StrategyPayForConversionAddMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }
}
