package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionCrrAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class StrategyPayForConversionCrrAddMap extends ModelBeanMap<StrategyPayForConversionCrrAddMap> {

    public static final String CRR = "crr";
    public static final String GOAL_ID = "goalId";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public static final Integer DEFAULT_CRR = 100;
    public static final Integer MIN_CRR = 1;
    public static final Integer MAX_CRR = 500;
    public static final Long DEFAULT_WEEKLY_SPEND_LIMIT = 500_000_000L;
    public static final Long MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID = 13L;

    public StrategyPayForConversionCrrAddMap() {
        super();
        setBean(new StrategyPayForConversionCrrAdd());
    }

    @Override
    public StrategyPayForConversionCrrAddMap put(Object name, Object value) {
        super.put(name, value);
        return this;
    }

    public StrategyPayForConversionCrrAddMap withCrr(Integer crr) {
        return this.put(CRR, crr);
    }

    public StrategyPayForConversionCrrAddMap withGoalId(Long goalId) {
        return this.put(GOAL_ID, goalId);
    }

    public StrategyPayForConversionCrrAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        return this.put(WEEKLY_SPEND_LIMIT, weeklySpendLimit);
    }

}
