package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionCrr;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class StrategyPayForConversionCrrMap extends ModelBeanMap<StrategyPayForConversionCrrMap> {

    public static final String CRR = "crr";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String GOAL_ID = "goalId";

    public StrategyPayForConversionCrrMap() {
        super();
        setBean(new StrategyPayForConversionCrr());
    }

    @Override
    public StrategyPayForConversionCrrMap put(Object name, Object value) {
        super.put(name, value);
        return this;
    }

    public StrategyPayForConversionCrrMap withCrr(Integer crr) {
        return this.put(CRR, crr);
    }

    public StrategyPayForConversionCrrMap withWeeklySpendLimit(Long weeklySpendLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyPayForConversionWeeklySpendLimit(weeklySpendLimit);
        return this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
    }

    public StrategyPayForConversionCrrMap withGoalId(Long goalId) {
        return this.put(GOAL_ID, goalId);
    }
}
