package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpa;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversion;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pashkus on 25.05.20.
 */
public class StrategyPayForConversionMap extends ModelBeanMap<StrategyPayForConversionMap> {

    public static final String CPA = "cpa";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String GOAL_ID = "goalId";

    public StrategyPayForConversionMap() {
        super();
        setBean(new StrategyPayForConversion());
    }

    public StrategyPayForConversionMap(StrategyPayForConversion strategyPayForConversion) {
        super();
        setBean(strategyPayForConversion);
    }

    public StrategyPayForConversionMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyPayForConversionMap defaultStrategyPayForConversion(Currency currency) {
        Money minCpa = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withCpa(minCpa.bidLong().longValue())
                .withWeeklySpendLimit(null);
    }

    public StrategyPayForConversionMap withCpa(Long cpa) {
        this.put(CPA, cpa);
        return this;
    }

    public StrategyPayForConversionMap withWeeklySpendLimit(Long weeklySpendLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyPayForConversionWeeklySpendLimit(weeklySpendLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }

    public StrategyPayForConversionMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }
}
