package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionAdd;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerCampaignAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by pashkus on 25.05.20.
 */
public class StrategyPayForConversionPerCampaignAddMap extends ModelBeanMap<StrategyPayForConversionPerCampaignAddMap> {

    public static final String CPA = "cpa";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String GOAL_ID = "goalId";

    public StrategyPayForConversionPerCampaignAddMap() {
        super();
        setBean(new StrategyPayForConversionPerCampaignAdd());
    }

    public StrategyPayForConversionPerCampaignAddMap(StrategyPayForConversionPerCampaignAdd strategyPayForConversionAdd) {
        super();
        setBean(strategyPayForConversionAdd);
    }

    public StrategyPayForConversionPerCampaignAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyPayForConversionPerCampaignAddMap defaultStrategyPayForConversion(Currency currency) {
        Money minCpa = MoneyCurrency.get(currency).getMinAveragePrice();
        return this.withCpa(minCpa.bidLong().longValue());
    }

    public StrategyPayForConversionPerCampaignAddMap withCpa(Long cpa) {
        this.put(CPA, cpa);
        return this;
    }

    public StrategyPayForConversionPerCampaignAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        this.put(WEEKLY_SPEND_LIMIT, weeklySpendLimit);
        return this;
    }

    public StrategyPayForConversionPerCampaignAddMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }
}
