package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerFilterAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

public class StrategyPayForConversionPerFilterAddMap extends ModelBeanMap<StrategyPayForConversionPerFilterAddMap> {

    public static final String CPA = "cpa";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String GOAL_ID = "goalId";

    public StrategyPayForConversionPerFilterAddMap() {
        super();
        setBean(new StrategyPayForConversionPerFilterAdd());
    }

    public StrategyPayForConversionPerFilterAddMap(StrategyPayForConversionPerFilterAdd strategyPayForConversionAdd) {
        super();
        setBean(strategyPayForConversionAdd);
    }

    public StrategyPayForConversionPerFilterAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyPayForConversionPerFilterAddMap defaultStrategyPayForConversion(Currency currency) {
        Money minCpa = MoneyCurrency.get(currency).getMinAveragePrice();
        return this.withCpa(minCpa.bidLong().longValue());
    }

    public StrategyPayForConversionPerFilterAddMap withCpa(Long cpa) {
        this.put(CPA, cpa);
        return this;
    }

    public StrategyPayForConversionPerFilterAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        this.put(WEEKLY_SPEND_LIMIT, weeklySpendLimit);
        return this;
    }

    public StrategyPayForConversionPerFilterAddMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }
}
