package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerFilter;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

public class StrategyPayForConversionPerFilterMap extends ModelBeanMap<StrategyPayForConversionPerFilterMap> {
    public static final String CPA = "cpa";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String GOAL_ID = "goalId";

    public StrategyPayForConversionPerFilterMap() {
        super();
        setBean(new StrategyPayForConversionPerFilter());
    }

    public StrategyPayForConversionPerFilterMap(StrategyPayForConversionPerFilter strategyPayForConversion) {
        super();
        setBean(strategyPayForConversion);
    }

    public StrategyPayForConversionPerFilterMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyPayForConversionPerFilterMap defaultStrategyPayForConversion(Currency currency) {
        Money minCpa = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withCpa(minCpa.bidLong().longValue())
                .withWeeklySpendLimit(null);
    }

    public StrategyPayForConversionPerFilterMap withCpa(Long cpa) {
        this.put(CPA, cpa);
        return this;
    }

    public StrategyPayForConversionPerFilterMap withWeeklySpendLimit(Long weeklySpendLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyPayForConversionPerFilterWeeklySpendLimit(weeklySpendLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }

    public StrategyPayForConversionPerFilterMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }
}
