package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyPayForInstallAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by snirinn on 21.09.20.
 */
public class StrategyPayForInstallAddMap extends ModelBeanMap<StrategyPayForInstallAddMap> {

    public static final String AVERAGE_CPI = "averageCpi";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public StrategyPayForInstallAddMap() {
        super();
        setBean(new StrategyPayForInstallAdd());
    }

    public StrategyPayForInstallAddMap(StrategyPayForInstallAdd strategyPayForInstallAdd) {
        super();
        setBean(strategyPayForInstallAdd);
    }

    public StrategyPayForInstallAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyPayForInstallAddMap defaultStrategyPayForConversion(Currency currency) {
        Money averageCpi = MoneyCurrency.get(currency).getMinAveragePrice();
        return this.withAverageCpi(averageCpi.bidLong().longValue());
    }

    public StrategyPayForInstallAddMap withAverageCpi(Long averageCpi) {
        this.put(AVERAGE_CPI, averageCpi);
        return this;
    }

    public StrategyPayForInstallAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        this.put(WEEKLY_SPEND_LIMIT, weeklySpendLimit);
        return this;
    }
}
