package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversion;
import com.yandex.direct.api.v5.campaigns.StrategyPayForInstall;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by snirinn on 15.09.20.
 */
public class StrategyPayForInstallMap extends ModelBeanMap<StrategyPayForInstallMap> {

    public static final String AVERAGE_CPI = "averageCpi";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public StrategyPayForInstallMap() {
        super();
        setBean(new StrategyPayForInstall());
    }

    public StrategyPayForInstallMap(StrategyPayForInstall strategyPayForInstall) {
        super();
        setBean(strategyPayForInstall);
    }

    public StrategyPayForInstallMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyPayForInstallMap defaultStrategyPayForInstall(Currency currency) {
        Money minCpi = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withAverageCpi(minCpi.bidLong().longValue())
                .withWeeklySpendLimit(null);
    }

    public StrategyPayForInstallMap withAverageCpi(Long averageCpi) {
        this.put(AVERAGE_CPI, averageCpi);
        return this;
    }

    public StrategyPayForInstallMap withWeeklySpendLimit(Long weeklySpendLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyPayForInstallWeeklySpendLimit(weeklySpendLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }
}
