package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyWbAverageCpvAdd;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

public class StrategyWbAverageCpvAddMap extends StrategyAverageCpvAddBaseMap<StrategyWbAverageCpvAddMap> {

    public StrategyWbAverageCpvAddMap() {
        super();
        setBean(new StrategyWbAverageCpvAdd());
    }

    public StrategyWbAverageCpvAddMap(StrategyWbAverageCpvAddMap strategyWbAverageCpvAddMap) {
        super();
        setBean(strategyWbAverageCpvAddMap);
    }

    public StrategyWbAverageCpvAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyWbAverageCpvAddMap defaultStrategyWbAverageCpv(Currency currency) {
        Money averageCpv = MoneyCurrency.get(currency).getMinAvgCpv();
        Money weeklyBudget = MoneyCurrency.get(currency).getMaxWeeklyBudgetAmount();
        return this.withAverageCpv(averageCpv.bidLong().longValue()).withSpendLimit(weeklyBudget.bidLong().longValue());
    }
}
