package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyWbMaximumImpressionsAdd;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by gerdler on 08.09.18.
 */
public class StrategyWbMaximumImpressionsAddMap extends StrategyMaximizeImpressionsAddBaseMap<StrategyWbMaximumImpressionsAddMap> {

    public StrategyWbMaximumImpressionsAddMap() {
        super();
        setBean(new StrategyWbMaximumImpressionsAdd());
    }

    public StrategyWbMaximumImpressionsAddMap(StrategyWbMaximumImpressionsAddMap strategyWbMaximumImpressionsAddMap) {
        super();
        setBean(strategyWbMaximumImpressionsAddMap);
    }

    public StrategyWbMaximumImpressionsAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyWbMaximumImpressionsAddMap defaultStrategyWbMaximumImpressions(Currency currency) {
        Money averageCpm = MoneyCurrency.get(currency).getMinCpmPrice();
        Money weeklyBudget = MoneyCurrency.get(currency).getMaxWeeklyBudgetAmount();
        return this.withAverageCpm(averageCpm.bidLong().longValue()).withSpendLimit(weeklyBudget.bidLong().longValue());
    }
}
