package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 19.10.15.
 */
public class StrategyWeeklyBudgetBaseMap<T> extends ModelBeanMap<StrategyWeeklyBudgetBaseMap> {

    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public StrategyWeeklyBudgetBaseMap() {
        super();
    }

    public T withBidCeiling(Long bidCeiling) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyWeeklyBudgetBaseBidCeiling(bidCeiling);
        this.put(BID_CEILING, jaxbElement);
        return (T) this;
    }

    public T withWeeklySpendLimit(Long weeklySpendLimit) {
        this.put(WEEKLY_SPEND_LIMIT, weeklySpendLimit);
        return (T) this;
    }
}
