package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyWeeklyClickPackageAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 01.09.15.
 */
public class StrategyWeeklyClickPackageAddMap extends ModelBeanMap<StrategyWeeklyClickPackageAddMap> {

    public static final String BID_CEILING = "bidCeiling";
    public static final String AVERAGE_CPC = "averageCpc";
    public static final String CLICKS_PER_WEEK = "clicksPerWeek";

    public static final Long DEFAULT_CLICKS_PER_WEEK = 1000L;
    public static final Long MIN_CLICKS_PER_WEEK = 100L;

    public StrategyWeeklyClickPackageAddMap() {
        super();
        setBean(new StrategyWeeklyClickPackageAdd());
    }

    public StrategyWeeklyClickPackageAddMap(StrategyWeeklyClickPackageAdd strategyWeeklyClickPackage) {
        super();
        setBean(strategyWeeklyClickPackage);
    }

    public StrategyWeeklyClickPackageAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyWeeklyClickPackageAddMap defaultStrategyWeeklyClickPackage() {
        return this.withClicksPerWeek(DEFAULT_CLICKS_PER_WEEK);
    }

    public StrategyWeeklyClickPackageAddMap withBidCeiling(Long bidCeling) {
        this.put(BID_CEILING, bidCeling);
        return this;
    }

    public StrategyWeeklyClickPackageAddMap withClicksPerWeek(Long clicksPerWeek) {
        this.put(CLICKS_PER_WEEK, clicksPerWeek);
        return this;
    }

    public StrategyWeeklyClickPackageAddMap withAverageCpc(Long averagePrice) {
        this.put(AVERAGE_CPC, averagePrice);
        return this;
    }
}
