package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.PriorityGoalsArray;
import com.yandex.direct.api.v5.campaigns.RelevantKeywordsSettingAdd;
import com.yandex.direct.api.v5.campaigns.TextCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignStrategyAdd;
import com.yandex.direct.api.v5.general.ArrayOfInteger;
import com.yandex.direct.api.v5.general.AttributionModelEnum;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfIntegerMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 05.08.15.
 */
public class TextCampaignAddItemMap extends ModelBeanMap<TextCampaignAddItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String COUNTER_IDS = "counterIds";
    public static final String RELEVANT_KEYWORDS = "relevantKeywords";
    public static final String PRIORITY_GOALS = "priorityGoals";
    public static final String ATTRIBUTION_MODEL = "attributionModel";

    public static final int MAX_AMOUNT_OF_COUNTER_IDS = 100;

    public TextCampaignAddItemMap() {
        super();
        setBean(new TextCampaignAddItem());
    }

    public TextCampaignAddItemMap(TextCampaignAddItem textCampaignAddItem) {
        super();
        setBean(textCampaignAddItem);
    }

    public TextCampaignAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextCampaignAddItemMap withBiddingStrategy(TextCampaignStrategyAddMap textCampaignStrategyAddMap) {
        TextCampaignStrategyAdd textCampaignStrategy =
                ((textCampaignStrategyAddMap == null) ? null
                        : (TextCampaignStrategyAdd) (textCampaignStrategyAddMap.getBean()));
        this.put(BIDDING_STRATEGY, textCampaignStrategy);
        return this;
    }

    public TextCampaignAddItemMap withSettings(TextCampaignSettingMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public TextCampaignAddItemMap defaultTextCampaign() {
        return this.withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy());
    }

    public TextCampaignAddItemMap textCampaignWithStrategies(
            TextCampaignSearchStrategyTypeEnum searchStrategy,
            TextCampaignNetworkStrategyTypeEnum networkStrategy)
    {
        return this.withBiddingStrategy(new TextCampaignStrategyAddMap()
                .withSearch(new TextCampaignSearchStrategyAddMap().withBiddingStrategyType(searchStrategy))
                .withNetwork(new TextCampaignNetworkStrategyAddMap().withBiddingStrategyType(networkStrategy)));
    }

    public TextCampaignAddItemMap withRelevantKeywords(RelevantKeywordsSettingAddMap relevantKeywordsSettingAddMap) {
        RelevantKeywordsSettingAdd relevantKeywordsSettingAdd =
                (RelevantKeywordsSettingAdd) ((relevantKeywordsSettingAddMap == null) ? null
                        : relevantKeywordsSettingAddMap.getBean());
        return this.put(RELEVANT_KEYWORDS, relevantKeywordsSettingAdd);
    }

    public TextCampaignAddItemMap withCounterIds(ArrayOfIntegerMap arrayOfIntegerMap) {
        ArrayOfInteger counterIds =
                (ArrayOfInteger) ((arrayOfIntegerMap == null) ? null : arrayOfIntegerMap.getBean());
        return this.put(COUNTER_IDS, counterIds);
    }

    public TextCampaignAddItemMap withCounterIds(Integer... counterIds) {
        ArrayOfIntegerMap arrayOfIntegerMap =
                (counterIds == null) ? null : new ArrayOfIntegerMap().withItems(counterIds);
        return this.withCounterIds(arrayOfIntegerMap);
    }

    public TextCampaignAddItemMap withPriorityGoals(PriorityGoalsArrayMap priorityGoalsArrayMap) {
        PriorityGoalsArray priorityGoals =
                (PriorityGoalsArray) ((priorityGoalsArrayMap == null) ? null : priorityGoalsArrayMap.getBean());
        return this.put(PRIORITY_GOALS, priorityGoals);
    }

    public TextCampaignAddItemMap withPriorityGoals(PriorityGoalsItemMap... priorityGoals) {
        PriorityGoalsArrayMap priorityGoalsArray =
                (priorityGoals == null) ? null : new PriorityGoalsArrayMap().withItems(priorityGoals);
        return this.withPriorityGoals(priorityGoalsArray);
    }

    public TextCampaignAddItemMap withAttributionModel(AttributionModelEnum attributionModel) {
        this.put(ATTRIBUTION_MODEL, attributionModel);
        return this;
    }
}
