package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.RelevantKeywordsSetting;
import com.yandex.direct.api.v5.general.ArrayOfInteger;
import com.yandex.direct.api.v5.general.AttributionModelEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfIntegerMap;

/**
 * Created by pavryabov on 05.08.15.
 */
public class TextCampaignBaseMap<T> extends ModelBeanMap<TextCampaignBaseMap> {

    public static final String COUNTER_IDS = "counterIds";
    public static final String RELEVANT_KEYWORDS = "relevantKeywords";
    public static final String ATTRIBUTION_MODEL = "attributionModel";

    public TextCampaignBaseMap() {
        super();
    }

    public T withCounterIds(ArrayOfIntegerMap arrayOfIntegerMap) {
        ArrayOfInteger counterIds =
                (ArrayOfInteger) ((arrayOfIntegerMap == null) ? null : arrayOfIntegerMap.getBean());
        JAXBElement<ArrayOfInteger> jaxbElement =
                new ObjectFactory().createTextCampaignBaseCounterIds(counterIds);
        this.put(COUNTER_IDS, jaxbElement);
        return (T) this;
    }

    public T withCounterIds(Integer... items) {
        ArrayOfIntegerMap arrayOfIntegerMap = (items == null) ? null : new ArrayOfIntegerMap().withItems(items);
        return this.withCounterIds(arrayOfIntegerMap);
    }

    public T withRelevantKeywords(RelevantKeywordsSettingMap relevantKeywordsSettingMap) {
        RelevantKeywordsSetting relevantKeywordsSetting =
                (RelevantKeywordsSetting) ((relevantKeywordsSettingMap == null) ? null
                        : relevantKeywordsSettingMap.getBean());
        JAXBElement<RelevantKeywordsSetting> jaxbElement =
                new ObjectFactory().createTextCampaignBaseRelevantKeywords(relevantKeywordsSetting);
        this.put(RELEVANT_KEYWORDS, jaxbElement);
        return (T) this;
    }

    public T withAttributionModel(AttributionModelEnum attributionModel) {
        this.put(ATTRIBUTION_MODEL, attributionModel);
        return (T) this;
    }

}
