package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by pavryabov on 19.10.15.
 */
public class TextCampaignSearchStrategyMap extends TextCampaignStrategyBaseMap<TextCampaignSearchStrategyMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public TextCampaignSearchStrategyMap() {
        super();
        setBean(new TextCampaignSearchStrategy());
    }

    public TextCampaignSearchStrategyMap(TextCampaignSearchStrategy textCampaignSearchStrategy) {
        super();
        setBean(textCampaignSearchStrategy);
    }

    public TextCampaignSearchStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextCampaignSearchStrategyMap withBiddingStrategyType(
            TextCampaignSearchStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public TextCampaignSearchStrategyMap defaultServingOff() {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.SERVING_OFF);
    }

    public TextCampaignSearchStrategyMap defaultHighestPosition() {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION);
    }

    public TextCampaignSearchStrategyMap defaultWbMaximumClicks(Currency currency) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public TextCampaignSearchStrategyMap defaultWbMaximumConversionRate(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                .withWbMaximumConversionRate(new StrategyMaximumConversionRateMap()
                        .defaultMaximumConversionRateParams(currency)
                        .withGoalId(goalId));
    }

    public TextCampaignSearchStrategyMap defaultAverageCpc(Currency currency) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public TextCampaignSearchStrategyMap defaultAverageCpa(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                .withAverageCpa(new StrategyAverageCpaMap()
                        .defaultStrategyAverageCpa(currency)
                        .withGoalId(goalId));
    }

    public TextCampaignSearchStrategyMap defaultPayForConversion(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION)
                .withPayForConversion(new StrategyPayForConversionMap()
                        .defaultStrategyPayForConversion(currency)
                        .withGoalId(goalId));
    }

    public TextCampaignSearchStrategyMap defaultAverageRoi(Long goalId) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                .withAverageRoi(new StrategyAverageRoiMap()
                        .defaultStrategyAverageRoi()
                        .withGoalId(goalId));
    }
    
    public TextCampaignSearchStrategyMap defaultAverageCrr(Long goalId) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CRR)
                .withAverageCrr(new StrategyAverageCrrMap()
                        .defaultStrategyAverageCrr()
                        .withGoalId(goalId));
    }
}

