package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyAverageCpa;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaAdd;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcAdd;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCrrAdd;
import com.yandex.direct.api.v5.campaigns.StrategyAverageRoiAdd;
import com.yandex.direct.api.v5.campaigns.StrategyMaximumClicksAdd;
import com.yandex.direct.api.v5.campaigns.StrategyMaximumConversionRateAdd;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionAdd;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionCrrAdd;
import com.yandex.direct.api.v5.campaigns.StrategyWeeklyClickPackageAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 05.08.15.
 */
public class TextCampaignStrategyAddBaseMap<T> extends ModelBeanMap<TextCampaignStrategyAddBaseMap> {

    public static final String WB_MAXIMUM_CLICKS = "wbMaximumClicks";
    public static final String WB_MAXIMUM_CONVERSION_RATE = "wbMaximumConversionRate";
    public static final String AVERAGE_CPC = "averageCpc";
    public static final String AVERAGE_CPA = "averageCpa";
    public static final String PAY_FOR_CONVERSION = "payForConversion";
    public static final String PAY_FOR_CONVERSION_CRR = "payForConversionCrr";
    public static final String WEEKLY_CLICK_PACKAGE = "weeklyClickPackage";
    public static final String AVERAGE_ROI = "averageRoi";
    public static final String AVERAGE_CRR = "averageCrr";

    public TextCampaignStrategyAddBaseMap() {
        super();
    }

    public T withWbMaximumClicks(StrategyMaximumClicksAddMap paramsMap) {
        StrategyMaximumClicksAdd strategyMaximumClicks =
                ((paramsMap == null) ? null : (StrategyMaximumClicksAdd) (paramsMap.getBean()));
        this.put(WB_MAXIMUM_CLICKS, strategyMaximumClicks);
        return (T) this;
    }

    public T withWbMaximumConversionRate(StrategyMaximumConversionRateAddMap paramsMap) {
        StrategyMaximumConversionRateAdd params =
                ((paramsMap == null) ? null : (StrategyMaximumConversionRateAdd) (paramsMap.getBean()));
        this.put(WB_MAXIMUM_CONVERSION_RATE, params);
        return (T) this;
    }

    public T withAverageCpc(StrategyAverageCpcAddMap paramsMap) {
        StrategyAverageCpcAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpcAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPC, params);
        return (T) this;
    }

    public T withAverageCpa(StrategyAverageCpaAddMap paramsMap) {
        StrategyAverageCpaAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpaAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPA, params);
        return (T) this;
    }

    public T withPayForConversion(StrategyPayForConversionAddMap paramsMap) {
        StrategyPayForConversionAdd params =
                ((paramsMap == null) ? null : (StrategyPayForConversionAdd) (paramsMap.getBean()));
        this.put(PAY_FOR_CONVERSION, params);
        return (T) this;
    }

    public T withPayForConversionCrr(StrategyPayForConversionCrrAddMap paramsMap) {
        StrategyPayForConversionCrrAdd params =
                paramsMap == null ? null : (StrategyPayForConversionCrrAdd) paramsMap.getBean();
        this.put(PAY_FOR_CONVERSION_CRR, params);
        return (T) this;
    }

    public T withWeeklyClickPackage(StrategyWeeklyClickPackageAddMap paramsMap) {
        StrategyWeeklyClickPackageAdd params =
                ((paramsMap == null) ? null : (StrategyWeeklyClickPackageAdd) (paramsMap.getBean()));
        this.put(WEEKLY_CLICK_PACKAGE, params);
        return (T) this;
    }

    public T withAverageRoi(StrategyAverageRoiAddMap paramsMap) {
        StrategyAverageRoiAdd params =
                ((paramsMap == null) ? null : (StrategyAverageRoiAdd) (paramsMap.getBean()));
        this.put(AVERAGE_ROI, params);
        return (T) this;
    }

    public T withAverageCrr(StrategyAverageCrrAddMap paramsMap) {
        StrategyAverageCrrAdd params =
                (paramsMap == null) ? null : (StrategyAverageCrrAdd) (paramsMap.getBean());
        this.put(AVERAGE_CRR, params);
        return (T) this;
    }
}
