package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignStrategyAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 05.08.15.
 */
public class TextCampaignStrategyAddMap extends ModelBeanMap<TextCampaignStrategyAddMap> {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";

    public TextCampaignStrategyAddMap() {
        super();
        setBean(new TextCampaignStrategyAdd());
    }

    public TextCampaignStrategyAddMap(TextCampaignStrategyAdd textCampaignStrategy) {
        super();
        setBean(textCampaignStrategy);
    }

    public TextCampaignStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextCampaignStrategyAddMap withSearch(TextCampaignSearchStrategyAddMap textCampaignSearchStrategyAddMap) {
        TextCampaignSearchStrategyAdd textCampaignSearchStrategy =
                ((textCampaignSearchStrategyAddMap == null) ? null
                        : (com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyAdd) (textCampaignSearchStrategyAddMap
                                .getBean()));
        this.put(SEARCH, textCampaignSearchStrategy);
        return this;
    }

    public TextCampaignStrategyAddMap withNetwork(TextCampaignNetworkStrategyAddMap textCampaignNetworkStrategyAddMap) {
        TextCampaignNetworkStrategyAdd textCampaignNetworkStrategy =
                ((textCampaignNetworkStrategyAddMap == null) ? null
                        : (TextCampaignNetworkStrategyAdd) (textCampaignNetworkStrategyAddMap.getBean()));
        this.put(NETWORK, textCampaignNetworkStrategy);
        return this;
    }

    public TextCampaignStrategyAddMap defaultTextCampaignStrategy() {
        return this
                .withSearch(new TextCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                .withNetwork(new TextCampaignNetworkStrategyAddMap()
                        .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE));
    }
}
