package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.PriorityGoalsUpdateSetting;
import com.yandex.direct.api.v5.campaigns.TextCampaignStrategy;
import com.yandex.direct.api.v5.campaigns.TextCampaignUpdateItem;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by ginger on 21.08.15.
 */
public class TextCampaignUpdateItemMap extends TextCampaignBaseMap<TextCampaignUpdateItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String PRIORITY_GOALS = "priorityGoals";

    public TextCampaignUpdateItemMap() {
        super();
        setBean(new TextCampaignUpdateItem());
    }

    public TextCampaignUpdateItemMap(TextCampaignUpdateItem textCampaignUpdateItem) {
        super();
        setBean(textCampaignUpdateItem);
    }

    public TextCampaignUpdateItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextCampaignUpdateItemMap withBiddingStrategy(TextCampaignStrategyMap textCampaignStrategyMap) {
        TextCampaignStrategy textCampaignStrategy =
                ((textCampaignStrategyMap == null) ? null : (TextCampaignStrategy) (textCampaignStrategyMap.getBean()));
        this.put(BIDDING_STRATEGY, textCampaignStrategy);
        return this;
    }

    public TextCampaignUpdateItemMap withSettings(TextCampaignSettingMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public TextCampaignUpdateItemMap withPriorityGoals(PriorityGoalsUpdateSettingMap priorityGoalsUpdateSettingMap) {
        PriorityGoalsUpdateSetting priorityGoalsUpdateSetting = (PriorityGoalsUpdateSetting)
                ((priorityGoalsUpdateSettingMap == null) ? null
                        : priorityGoalsUpdateSettingMap.getBean());
        JAXBElement<PriorityGoalsUpdateSetting> jaxbElement =
                new ObjectFactory().createTextCampaignUpdateItemPriorityGoals(priorityGoalsUpdateSetting);
        return this.put(PRIORITY_GOALS, jaxbElement);
    }

    public TextCampaignUpdateItemMap withPriorityGoals(PriorityGoalsUpdateItemMap... priorityGoalsUpdate) {
        PriorityGoalsUpdateSettingMap priorityUpdateSettingMap =
                (priorityGoalsUpdate == null) ? null : new PriorityGoalsUpdateSettingMap().withItems(priorityGoalsUpdate);
        return this.withPriorityGoals(priorityUpdateSettingMap);
    }
}
