package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.Notification;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.irt.testutils.RandomUtils;

/**
 * Created by pavryabov on 05.08.15.
 */
public class CampaignBaseMap<T> extends ModelBeanMap<CampaignBaseMap> {

    public static final String CLIENT_INFO = "clientInfo";
    public static final String TIME_TARGETING = "timeTargeting";
    public static final String TIME_ZONE = "timeZone";
    public static final String NOTIFICATION = "notification";

    public CampaignBaseMap() {
        super();
    }


    public T withClientInfo(String clientInfo) {
        this.put(CLIENT_INFO, clientInfo);
        return (T) this;
    }

    public T withTimeZone(String timeZone) {
        this.put(TIME_ZONE, timeZone);
        return (T) this;
    }

    public T withNotification(NotificationMap notificationMap) {
        Notification notification =
                ((notificationMap == null) ? null : (Notification) (notificationMap.getBean()));
        this.put(NOTIFICATION, notification);
        return (T) this;
    }

    public static String generateRandomNotPrivateIp() {
        return String.valueOf(RandomUtils.getRandomInteger(40, 126)) + '.' +
                String.valueOf(RandomUtils.getRandomInteger(1, 255)) + '.' +
                String.valueOf(RandomUtils.getRandomInteger(1, 255)) + '.' +
                String.valueOf(RandomUtils.getRandomInteger(1, 255));
    }

}
