package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.CampaignAssistant;
import com.yandex.direct.api.v5.campaignsext.CampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.CampaignStateGetEnum;
import com.yandex.direct.api.v5.campaignsext.CampaignStatusPaymentEnum;
import com.yandex.direct.api.v5.campaignsext.CampaignTypeGetEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.DailyBudget;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.FundsParam;
import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.TextCampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.TimeTargeting;
import com.yandex.direct.api.v5.general.ArrayOfString;
import com.yandex.direct.api.v5.general.CurrencyEnum;
import com.yandex.direct.api.v5.general.Statistics;
import com.yandex.direct.api.v5.general.StatusEnum;

import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;
import ru.yandex.autotests.directapi.model.api5.general.StatisticsMap;

/**
 * Created by ginger on 22.07.15.
 */
public class CampaignGetItemMap extends CampaignBaseMap<CampaignGetItemMap> {

    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String START_DATE = "startDate";
    public static final String TYPE = "type";
    public static final String STATUS = "status";
    public static final String STATE = "state";
    public static final String STATUS_PAYMENT = "statusPayment";
    public static final String STATUS_CLARIFICATION = "statusClarification";
    public static final String SOURCE_ID = "sourceId";
    public static final String STATISTICS = "statistics";
    public static final String CURRENCY = "currency";
    public static final String FUNDS = "funds";
    public static final String REPRESENTED_BY = "representedBy";
    public static final String DAILY_BUDGET = "dailyBudget";
    public static final String END_DATE = "endDate";
    public static final String NEGATIVE_KEYWORDS = "negativeKeywords";
    public static final String BLOCKED_IPS = "blockedIps";
    public static final String EXCLUDED_SITES = "excludedSites";
    public static final String TEXT_CAMPAIGN = "textCampaign";
    public static final String MOBILE_APP_CAMPAIGN = "mobileAppCampaign";
    public static final String DYNAMIC_TEXT_CAMPAIGN = "dynamicTextCampaign";
    public static final String CPM_BANNER_CAMPAIGN = "cpmBannerCampaign";
    public static final String CONTENT_PROMOTION_CAMPAIGN = "contentPromotionCampaign";

    public CampaignGetItemMap() {
        super();
        setBean(new CampaignGetItem());
    }

    public CampaignGetItemMap(CampaignGetItem campaignGetItem) {
        super();
        setBean(campaignGetItem);
    }

    public CampaignGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CampaignGetItemMap withId(Long id) {
        this.put(ID, id);
        return this;
    }

    public CampaignGetItemMap withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public CampaignGetItemMap withStartDate(String startDate) {
        this.put(START_DATE, startDate);
        return this;
    }

    public CampaignGetItemMap withType(CampaignTypeGetEnum type) {
        this.put(TYPE, type);
        return this;
    }

    public CampaignGetItemMap withStatus(StatusEnum status) {
        this.put(STATUS, status);
        return this;
    }

    public CampaignGetItemMap withState(CampaignStateGetEnum state) {
        this.put(STATE, state);
        return this;
    }

    public CampaignGetItemMap withStatusPayment(CampaignStatusPaymentEnum statusPayment) {
        this.put(STATUS_PAYMENT, statusPayment);
        return this;
    }

    public CampaignGetItemMap withStatusClarification(String statusClarification) {
        this.put(STATUS_CLARIFICATION, statusClarification);
        return this;
    }

    public CampaignGetItemMap withSourceId(Long sourceId) {
        JAXBElement<Long> jaxbElement = new ObjectFactory().createCampaignGetItemSourceId(sourceId);
        this.put(SOURCE_ID, jaxbElement);
        return this;
    }

    public CampaignGetItemMap withStatistics(StatisticsMap statisticsMap) {
        Statistics statistics =
                ((statisticsMap == null) ? null : (Statistics) (statisticsMap.getBean()));
        this.put(STATISTICS, statistics);
        return this;
    }

    public CampaignGetItemMap withCurrency(CurrencyEnum currencyEnum) {
        this.put(CURRENCY, currencyEnum);
        return this;
    }

    public CampaignGetItemMap withFunds(FundsParamMap fundsParamMap) {
        FundsParam funds = ((fundsParamMap == null) ? null : (FundsParam) (fundsParamMap.getBean()));
        this.put(FUNDS, funds);
        return this;
    }

    public CampaignGetItemMap withRepresentedBy(CampaignAssistantMap campaignAssistantMap) {
        CampaignAssistant campaignAssistant =
                ((campaignAssistantMap == null) ? null : (CampaignAssistant) (campaignAssistantMap.getBean()));
        this.put(REPRESENTED_BY, campaignAssistant);
        return this;
    }

    public CampaignGetItemMap withDailyBudget(DailyBudgetMap dailyBudgetMap) {
        DailyBudget dailyBudget =
                ((dailyBudgetMap == null) ? null : (DailyBudget) (dailyBudgetMap.getBean()));
        JAXBElement jaxbElement = new ObjectFactory().createCampaignGetItemDailyBudget(dailyBudget);
        this.put(DAILY_BUDGET, jaxbElement);
        return this;
    }

    public CampaignGetItemMap withEndDate(String endDate) {
        JAXBElement<String> jaxbElement =
                new ObjectFactory().createCampaignGetItemEndDate(endDate);
        this.put(END_DATE, jaxbElement);
        return this;
    }

    public CampaignGetItemMap withNegativeKeywords(ArrayOfStringMap arrayOfStringMap) {
        ArrayOfString negativeKeywords =
                (ArrayOfString) ((arrayOfStringMap == null) ? null : arrayOfStringMap.getBean());
        JAXBElement<ArrayOfString> jaxbElement =
                new ObjectFactory().createCampaignGetItemNegativeKeywords(negativeKeywords);
        this.put(NEGATIVE_KEYWORDS, jaxbElement);
        return this;
    }

    public CampaignGetItemMap withNegativeKeywords(String... items) {
        ArrayOfStringMap arrayOfStringMap = (items == null) ? null : new ArrayOfStringMap().withItems(items);
        return this.withNegativeKeywords(arrayOfStringMap);
    }

    public CampaignGetItemMap withBlockedIps(ArrayOfStringMap arrayOfStringMap) {
        ArrayOfString blockedIps =
                (ArrayOfString) ((arrayOfStringMap == null) ? null : arrayOfStringMap.getBean());
        JAXBElement<ArrayOfString> jaxbElement =
                new ObjectFactory().createCampaignGetItemBlockedIps(blockedIps);
        this.put(BLOCKED_IPS, jaxbElement);
        return this;
    }

    public CampaignGetItemMap withBlockedIps(String... items) {
        ArrayOfStringMap arrayOfStringMap = (items == null) ? null : new ArrayOfStringMap().withItems(items);
        return this.withBlockedIps(arrayOfStringMap);
    }

    public CampaignGetItemMap withExcludedSites(ArrayOfStringMap arrayOfStringMap) {
        ArrayOfString excludedSites =
                (ArrayOfString) ((arrayOfStringMap == null) ? null : arrayOfStringMap.getBean());
        JAXBElement<ArrayOfString> jaxbElement =
                new ObjectFactory().createCampaignGetItemExcludedSites(excludedSites);
        this.put(EXCLUDED_SITES, jaxbElement);
        return this;
    }

    public CampaignGetItemMap withExcludedSites(String... items) {
        ArrayOfStringMap arrayOfStringMap = (items == null) ? null : new ArrayOfStringMap().withItems(items);
        return this.withExcludedSites(arrayOfStringMap);
    }

    public CampaignGetItemMap withTextCampaign(TextCampaignGetItemMap map) {
        TextCampaignGetItem textCampaignGetItem = ((map == null) ? null : (TextCampaignGetItem) (map.getBean()));
        this.put(TEXT_CAMPAIGN, textCampaignGetItem);
        return this;
    }

    public CampaignGetItemMap withMobileAppCampaign(MobileAppCampaignGetItemMap map) {
        MobileAppCampaignGetItem mobileAppCampaignGetItem =
                ((map == null) ? null : (MobileAppCampaignGetItem) (map.getBean()));
        this.put(MOBILE_APP_CAMPAIGN, mobileAppCampaignGetItem);
        return this;
    }

    public CampaignGetItemMap withDynamicTextCampaign(DynamicTextCampaignGetItemMap map) {
        DynamicTextCampaignGetItem dynamicTextCampaignGetItem =
                ((map == null) ? null : (DynamicTextCampaignGetItem) (map.getBean()));
        this.put(DYNAMIC_TEXT_CAMPAIGN, dynamicTextCampaignGetItem);
        return this;
    }

    public CampaignGetItemMap withCpmBannerCampaign(CpmBannerCampaignGetItemMap map) {
        CpmBannerCampaignGetItem cpmBannerCampaignGetItem =
                ((map == null) ? null : (CpmBannerCampaignGetItem) (map.getBean()));
        this.put(CPM_BANNER_CAMPAIGN, cpmBannerCampaignGetItem);
        return this;
    }

    public CampaignGetItemMap withContentPromotionCampaign(ContentPromotionCampaignGetItemMap map) {
        ContentPromotionCampaignGetItem contentPromotionCampaignGetItem =
                ((map == null) ? null : (ContentPromotionCampaignGetItem) (map.getBean()));
        this.put(CONTENT_PROMOTION_CAMPAIGN, contentPromotionCampaignGetItem);
        return this;
    }

    public CampaignGetItemMap withTimeTargeting(TimeTargetingMap timeTargetingMap) {
        TimeTargeting timeTargeting =
                (TimeTargeting) ((timeTargetingMap == null) ? null : timeTargetingMap.getBean());
        this.put(TIME_TARGETING, timeTargeting);
        return this;
    }

}
