package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.SmartCampaignUpdateItem;
import com.yandex.direct.api.v5.campaignsext.CampaignUpdateItem;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignUpdateItem;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignUpdateItem;
import com.yandex.direct.api.v5.campaignsext.DailyBudget;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignUpdateItem;
import com.yandex.direct.api.v5.campaignsext.MobileAppCampaignUpdateItem;
import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.TextCampaignUpdateItem;
import com.yandex.direct.api.v5.campaignsext.TimeTargeting;
import com.yandex.direct.api.v5.general.ArrayOfString;
import org.joda.time.DateTime;

import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;

/**
 * Created by ginger on 21.08.15.
 */
public class CampaignUpdateItemMap extends CampaignBaseMap<CampaignUpdateItemMap> {

    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String START_DATE = "startDate";
    public static final String DAILY_BUDGET = "dailyBudget";
    public static final String END_DATE = "endDate";
    public static final String NEGATIVE_KEYWORDS = "negativeKeywords";
    public static final String BLOCKED_IPS = "blockedIps";
    public static final String EXCLUDED_SITES = "excludedSites";
    public static final String TEXT_CAMPAIGN = "textCampaign";
    public static final String MOBILE_APP_CAMPAIGN = "mobileAppCampaign";
    public static final String DYNAMIC_TEXT_CAMPAIGN = "dynamicTextCampaign";
    public static final String CPM_BANNER_CAMPAIGN = "cpmBannerCampaign";
    public static final String SMART_CAMPAIGN = "smartCampaign";
    public static final String CONTENT_PROMOTION_CAMPAIGN = "contentPromotionCampaign";
    public static final String ATTRIBUTION_MODEL = "attributionModel";
    public static final int MAX_CLIENT_INFO_LENGTH = 100;
    public static final int MAX_NAME_LENGTH = 100;

    public static final String DEFAULT_NAME = "Тестовая кампания API5";

    public static final String DATE_PATTERN = "yyyy-MM-dd";

    public CampaignUpdateItemMap() {
        super();
        setBean(new CampaignUpdateItem());
    }

    public CampaignUpdateItemMap(CampaignUpdateItem campaignUpdateItem) {
        super();
        setBean(campaignUpdateItem);
    }

    public CampaignUpdateItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CampaignUpdateItemMap withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public CampaignUpdateItemMap withAttributionModel(String attributionModel) {
        this.put(ATTRIBUTION_MODEL, attributionModel);
        return this;
    }

    public CampaignUpdateItemMap withStartDate(String startDate) {
        this.put(START_DATE, startDate);
        return this;
    }

    public CampaignUpdateItemMap withId(Long id) {
        this.put(ID, id);
        return this;
    }

    public CampaignUpdateItemMap defaultCampaignUpdateItem() {
        return this
                .withName(DEFAULT_NAME + "(" + DateTime.now().toString("dd.MM HH:mm:ss") + ")")
                .withStartDate(DateTime.now().toString(DATE_PATTERN));
    }

    public CampaignUpdateItemMap withDailyBudget(DailyBudgetMap dailyBudgetMap) {
        DailyBudget dailyBudget =
                ((dailyBudgetMap == null) ? null : (DailyBudget) (dailyBudgetMap.getBean()));
        JAXBElement jaxbElement = new ObjectFactory().createCampaignUpdateItemDailyBudget(dailyBudget);
        this.put(DAILY_BUDGET, jaxbElement);
        return this;
    }

    public CampaignUpdateItemMap withEndDate(String endDate) {
        JAXBElement<String> jaxbElement =
                new ObjectFactory().createCampaignUpdateItemEndDate(endDate);
        this.put(END_DATE, jaxbElement);
        return this;
    }

    public CampaignUpdateItemMap withNegativeKeywords(ArrayOfStringMap arrayOfStringMap) {
        ArrayOfString negativeKeywords =
                (ArrayOfString) ((arrayOfStringMap == null) ? null : arrayOfStringMap.getBean());
        JAXBElement<ArrayOfString> jaxbElement =
                new ObjectFactory().createCampaignUpdateItemNegativeKeywords(negativeKeywords);
        this.put(NEGATIVE_KEYWORDS, jaxbElement);
        return this;
    }

    public CampaignUpdateItemMap withNegativeKeywords(String... items) {
        ArrayOfStringMap arrayOfStringMap = (items == null) ? null : new ArrayOfStringMap().withItems(items);
        return this.withNegativeKeywords(arrayOfStringMap);
    }

    public CampaignUpdateItemMap withBlockedIps(ArrayOfStringMap arrayOfStringMap) {
        ArrayOfString blockedIps =
                (ArrayOfString) ((arrayOfStringMap == null) ? null : arrayOfStringMap.getBean());
        JAXBElement<ArrayOfString> jaxbElement =
                new ObjectFactory().createCampaignUpdateItemBlockedIps(blockedIps);
        this.put(BLOCKED_IPS, jaxbElement);
        return this;
    }

    public CampaignUpdateItemMap withBlockedIps(String... items) {
        ArrayOfStringMap arrayOfStringMap = (items == null) ? null : new ArrayOfStringMap().withItems(items);
        return this.withBlockedIps(arrayOfStringMap);
    }

    public CampaignUpdateItemMap withExcludedSites(ArrayOfStringMap arrayOfStringMap) {
        ArrayOfString excludedSites =
                (ArrayOfString) ((arrayOfStringMap == null) ? null : arrayOfStringMap.getBean());
        JAXBElement<ArrayOfString> jaxbElement =
                new ObjectFactory().createCampaignUpdateItemExcludedSites(excludedSites);
        this.put(EXCLUDED_SITES, jaxbElement);
        return this;
    }

    public CampaignUpdateItemMap withExcludedSites(String... items) {
        ArrayOfStringMap arrayOfStringMap = (items == null) ? null : new ArrayOfStringMap().withItems(items);
        return this.withExcludedSites(arrayOfStringMap);
    }

    public CampaignUpdateItemMap withTextCampaign(TextCampaignUpdateItemMap textCampaignUpdateItemMap) {
        TextCampaignUpdateItem textCampaignUpdateItem =
                ((textCampaignUpdateItemMap == null) ? null
                        : (TextCampaignUpdateItem) (textCampaignUpdateItemMap.getBean()));
        this.put(TEXT_CAMPAIGN, textCampaignUpdateItem);
        return this;
    }

    public CampaignUpdateItemMap withMobileAppCampaign(MobileAppCampaignUpdateItemMap mobileAppCampaignUpdateItemMap) {
        MobileAppCampaignUpdateItem mobileAppCampaignUpdateItem =
                ((mobileAppCampaignUpdateItemMap == null) ? null
                        : (MobileAppCampaignUpdateItem) (mobileAppCampaignUpdateItemMap.getBean()));
        this.put(MOBILE_APP_CAMPAIGN, mobileAppCampaignUpdateItem);
        return this;
    }

    public CampaignUpdateItemMap withDynamicTextCampaign(
            DynamicTextCampaignUpdateItemMap dynamicTextCampaignUpdateItemMap)
    {
        DynamicTextCampaignUpdateItem dynamicTextCampaignUpdateItem =
                ((dynamicTextCampaignUpdateItemMap == null) ? null
                        : (DynamicTextCampaignUpdateItem) (dynamicTextCampaignUpdateItemMap.getBean()));
        this.put(DYNAMIC_TEXT_CAMPAIGN, dynamicTextCampaignUpdateItem);
        return this;
    }

    public  CampaignUpdateItemMap withCpmBannerCampaign(CpmBannerCampaignUpdateItemMap cpmBannerCampaignUpdateItemMap) {
        CpmBannerCampaignUpdateItem cpmBannerCampaignUpdateItem =
                ((cpmBannerCampaignUpdateItemMap == null) ? null
                        : (CpmBannerCampaignUpdateItem) (cpmBannerCampaignUpdateItemMap.getBean()));
        this.put(CPM_BANNER_CAMPAIGN, cpmBannerCampaignUpdateItem);
        return this;
    }

    public CampaignUpdateItemMap withSmartCampaign(
            SmartCampaignUpdateItemMap smartCampaignUpdateItemMap)
    {
        SmartCampaignUpdateItem smartCampaignUpdateItem =
                ((smartCampaignUpdateItemMap == null) ? null
                        : (SmartCampaignUpdateItem) (smartCampaignUpdateItemMap.getBean()));
        this.put(SMART_CAMPAIGN, smartCampaignUpdateItem);
        return this;
    }

    public CampaignUpdateItemMap withContentPromotionCampaign(ContentPromotionCampaignUpdateItemMap
                                                                      contentPromotionCampaign) {
        ContentPromotionCampaignUpdateItem contentPromotionCampaignUpdateItem =
                ((contentPromotionCampaign == null) ? null
                        : (ContentPromotionCampaignUpdateItem) (contentPromotionCampaign.getBean()));
        this.put(CONTENT_PROMOTION_CAMPAIGN, contentPromotionCampaignUpdateItem);
        return this;
    }

    public CampaignUpdateItemMap withTimeTargeting(TimeTargetingMap timeTargetingMap) {
        TimeTargeting timeTargeting =
                (TimeTargeting) ((timeTargetingMap == null) ? null : timeTargetingMap.getBean());
        this.put(TIME_TARGETING, timeTargeting);
        return this;
    }

}
