package ru.yandex.autotests.directapi.model.api5.campaignsext;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaignsext.CampaignStateEnum;
import com.yandex.direct.api.v5.campaignsext.CampaignStatusPaymentEnum;
import com.yandex.direct.api.v5.campaignsext.CampaignStatusSelectionEnum;
import com.yandex.direct.api.v5.campaignsext.CampaignTypeEnum;
import com.yandex.direct.api.v5.campaignsext.CampaignsSelectionCriteria;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 22.07.15.
 */
public class CampaignsSelectionCriteriaMap extends ModelBeanMap<CampaignsSelectionCriteriaMap> {
    public static final String IDS = "ids";
    public static final String STATES = "states";
    public static final String STATUSES = "statuses";
    public static final String STATUSES_PAYMENT = "statusesPayment";
    public static final String TYPES = "types";

    public static final Integer IDS_MAX_SIZE = 1000;


    public CampaignsSelectionCriteriaMap() {
        super();
        setBean(new CampaignsSelectionCriteria());
    }

    public CampaignsSelectionCriteriaMap(CampaignsSelectionCriteria campaignsextSelectionCriteria) {
        super();
        setBean(campaignsextSelectionCriteria);
    }

    public CampaignsSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CampaignsSelectionCriteriaMap withIds(Long... ids) {
        this.put(IDS, Arrays.asList(ids));
        return this;
    }

    public CampaignsSelectionCriteriaMap withStates(CampaignStateEnum... states) {
        this.put(STATES, Arrays.asList(states));
        return this;
    }

    public CampaignsSelectionCriteriaMap withStatuses(CampaignStatusSelectionEnum... statuses) {
        this.put(STATUSES, Arrays.asList(statuses));
        return this;
    }

    public CampaignsSelectionCriteriaMap withTypes(CampaignTypeEnum... types) {
        this.put(TYPES, Arrays.asList(types));
        return this;
    }


    public CampaignsSelectionCriteriaMap withStatusesPayment(CampaignStatusPaymentEnum... statusesPayment) {
        this.put(STATUSES_PAYMENT, Arrays.asList(statusesPayment));
        return this;
    }
}
