package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignAddItem;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignStrategyAdd;
import com.yandex.direct.api.v5.general.ArrayOfInteger;
import com.yandex.direct.api.v5.general.AttributionModelEnum;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfIntegerMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 17.11.15.
 */
public class ContentPromotionCampaignAddItemMap extends ModelBeanMap<ContentPromotionCampaignAddItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String ATTRIBUTION_MODEL = "attributionModel";
    public static final String COUNTER_IDS = "counterIds";

    public static final int MAX_AMOUNT_OF_COUNTER_IDS = 100;

    public ContentPromotionCampaignAddItemMap() {
        super();
        setBean(new ContentPromotionCampaignAddItem());
    }

    public ContentPromotionCampaignAddItemMap(ContentPromotionCampaignAddItem contentPromotionCampaignAddItem) {
        super();
        setBean(contentPromotionCampaignAddItem);
    }

    public ContentPromotionCampaignAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ContentPromotionCampaignAddItemMap withBiddingStrategy(
            ContentPromotionCampaignStrategyAddMap contentPromotionCampaignStrategyAddMap)
    {
        ContentPromotionCampaignStrategyAdd contentPromotionCampaignStrategyAdd =
                ((contentPromotionCampaignStrategyAddMap == null) ? null
                        : (ContentPromotionCampaignStrategyAdd) (contentPromotionCampaignStrategyAddMap.getBean()));
        this.put(BIDDING_STRATEGY, contentPromotionCampaignStrategyAdd);
        return this;
    }

    public ContentPromotionCampaignAddItemMap withSettings(ContentPromotionCampaignSettingMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public ContentPromotionCampaignAddItemMap defaultContentPromotionCampaign() {
        return this.withBiddingStrategy(new ContentPromotionCampaignStrategyAddMap().defaultContentPromotionCampaignStrategy());
    }

    public ContentPromotionCampaignAddItemMap withAttributionModel(AttributionModelEnum attributionModel) {
        this.put(ATTRIBUTION_MODEL, attributionModel);
        return this;
    }

    public ContentPromotionCampaignAddItemMap withCounterIds(ArrayOfIntegerMap arrayOfIntegerMap) {
        ArrayOfInteger counterIds =
                (ArrayOfInteger) ((arrayOfIntegerMap == null) ? null : arrayOfIntegerMap.getBean());
        return this.put(COUNTER_IDS, counterIds);
    }

    public ContentPromotionCampaignAddItemMap withCounterIds(Integer... items) {
        ArrayOfIntegerMap arrayOfIntegerMap = (items == null) ? null : new ArrayOfIntegerMap().withItems(items);
        return this.withCounterIds(arrayOfIntegerMap);
    }
}
