package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignStrategy;
import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.PriorityGoalsArray;
import com.yandex.direct.api.v5.general.AttributionModelEnum;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 17.11.15.
 */
public class ContentPromotionCampaignGetItemMap extends ContentPromotionCampaignBaseMap<ContentPromotionCampaignGetItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String PRIORITY_GOALS = "priorityGoals";

    public ContentPromotionCampaignGetItemMap() {
        setBean(new ContentPromotionCampaignGetItem());
    }

    public ContentPromotionCampaignGetItemMap(ContentPromotionCampaignGetItem contentPromotionCampaignGetItem) {
        super();
        setBean(contentPromotionCampaignGetItem);
    }

    public ContentPromotionCampaignGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ContentPromotionCampaignGetItemMap withBiddingStrategy(
            ContentPromotionCampaignStrategyMap contentPromotionCampaignStrategyMap)
    {
        ContentPromotionCampaignStrategy contentPromotionCampaignStrategy =
                ((contentPromotionCampaignStrategyMap == null) ? null
                        : (ContentPromotionCampaignStrategy) (contentPromotionCampaignStrategyMap.getBean()));
        this.put(BIDDING_STRATEGY, contentPromotionCampaignStrategy);
        return this;
    }

    public ContentPromotionCampaignGetItemMap withSettings(ContentPromotionCampaignSettingGetMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public ContentPromotionCampaignGetItemMap withAttributionModel(AttributionModelEnum attributionModel) {
        this.put(ATTRIBUTION_MODEL, attributionModel);
        return this;
    }

    public ContentPromotionCampaignGetItemMap defaultContentPromotionCampaign() {
        return this.withBiddingStrategy(new ContentPromotionCampaignStrategyMap().defaultContentPromotionCampaignStrategy());
    }
}
