package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignNetworkStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 17.11.15.
 */
public class ContentPromotionCampaignNetworkStrategyAddMap extends ModelBeanMap<ContentPromotionCampaignNetworkStrategyAddMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public ContentPromotionCampaignNetworkStrategyAddMap() {
        super();
        setBean(new ContentPromotionCampaignNetworkStrategyAdd());
    }

    public ContentPromotionCampaignNetworkStrategyAddMap(
            ContentPromotionCampaignNetworkStrategyAdd contentPromotionCampaignNetworkStrategyAdd)
    {
        super();
        setBean(contentPromotionCampaignNetworkStrategyAdd);
    }

    public ContentPromotionCampaignNetworkStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ContentPromotionCampaignNetworkStrategyAddMap withBiddingStrategyType(
            ContentPromotionCampaignNetworkStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public ContentPromotionCampaignNetworkStrategyAddMap defaultServingOff() {
        return this.withBiddingStrategyType(ContentPromotionCampaignNetworkStrategyTypeEnum.SERVING_OFF);
    }
}
