package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignNetworkStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 17.11.15.
 */
public class ContentPromotionCampaignNetworkStrategyMap extends ModelBeanMap<ContentPromotionCampaignNetworkStrategyMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public ContentPromotionCampaignNetworkStrategyMap() {
        super();
        setBean(new ContentPromotionCampaignNetworkStrategy());
    }

    public ContentPromotionCampaignNetworkStrategyMap(
            ContentPromotionCampaignNetworkStrategy contentPromotionCampaignNetworkStrategy)
    {
        super();
        setBean(contentPromotionCampaignNetworkStrategy);
    }

    public ContentPromotionCampaignNetworkStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ContentPromotionCampaignNetworkStrategyMap withBiddingStrategyType(
            ContentPromotionCampaignNetworkStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public ContentPromotionCampaignNetworkStrategyMap defaultServingOff() {
        return this.withBiddingStrategyType(ContentPromotionCampaignNetworkStrategyTypeEnum.SERVING_OFF);
    }
}
