package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by pavryabov on 17.11.15.
 */
public class ContentPromotionCampaignSearchStrategyAddMap extends ContentPromotionCampaignStrategyAddBaseMap<ContentPromotionCampaignSearchStrategyAddMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public ContentPromotionCampaignSearchStrategyAddMap() {
        super();
        setBean(new ContentPromotionCampaignSearchStrategyAdd());
    }

    public ContentPromotionCampaignSearchStrategyAddMap(
            ContentPromotionCampaignSearchStrategyAdd contentPromotionCampaignSearchStrategyAdd)
    {
        super();
        setBean(contentPromotionCampaignSearchStrategyAdd);
    }

    public ContentPromotionCampaignSearchStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ContentPromotionCampaignSearchStrategyAddMap withBiddingStrategyType(
            ContentPromotionCampaignSearchStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public ContentPromotionCampaignSearchStrategyAddMap defaultHighestPosition() {
        return this.withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.HIGHEST_POSITION);
    }

    public ContentPromotionCampaignSearchStrategyAddMap defaultWbMaximumClicks(Currency currency) {
        return this.withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public ContentPromotionCampaignSearchStrategyAddMap defaultAverageCpc(Currency currency) {
        return this.withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcAddMap()
                        .defaultStrategyAverageCpc(currency));
    }

}
