package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by pavryabov on 17.11.15.
 */
public class ContentPromotionCampaignSearchStrategyMap extends ContentPromotionCampaignStrategyBaseMap<ContentPromotionCampaignSearchStrategyMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public ContentPromotionCampaignSearchStrategyMap() {
        super();
        setBean(new ContentPromotionCampaignSearchStrategy());
    }

    public ContentPromotionCampaignSearchStrategyMap(ContentPromotionCampaignSearchStrategy contentPromotionCampaignSearchStrategy) {
        super();
        setBean(contentPromotionCampaignSearchStrategy);
    }

    public ContentPromotionCampaignSearchStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ContentPromotionCampaignSearchStrategyMap withBiddingStrategyType(
            ContentPromotionCampaignSearchStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public ContentPromotionCampaignSearchStrategyMap defaultHighestPosition() {
        return this.withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.HIGHEST_POSITION);
    }

    public ContentPromotionCampaignSearchStrategyMap defaultWbMaximumClicks(Currency currency) {
        return this.withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public ContentPromotionCampaignSearchStrategyMap defaultAverageCpc(Currency currency) {
        return this.withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcMap()
                        .defaultStrategyAverageCpc(currency));
    }

}
