package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSetting;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 17.11.15.
 */
public class ContentPromotionCampaignSettingMap extends ModelBeanMap<ContentPromotionCampaignSettingMap> {

    public static final String OPTION = "option";
    public static final String VALUE = "value";

    public ContentPromotionCampaignSettingMap() {
        super();
        setBean(new ContentPromotionCampaignSetting());
    }

    public ContentPromotionCampaignSettingMap(ContentPromotionCampaignSetting contentPromotionCampaignSetting) {
        super();
        setBean(contentPromotionCampaignSetting);
    }

    public ContentPromotionCampaignSettingMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ContentPromotionCampaignSettingMap withOption(ContentPromotionCampaignSettingsEnum option) {
        this.put(OPTION, option);
        return this;
    }

    public ContentPromotionCampaignSettingMap withValue(YesNoEnum value) {
        this.put(VALUE, value);
        return this;
    }
}
