package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignStrategyAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 17.11.15.
 */
public class ContentPromotionCampaignStrategyAddMap extends ModelBeanMap<ContentPromotionCampaignStrategyAddMap> {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";

    public ContentPromotionCampaignStrategyAddMap() {
        super();
        setBean(new ContentPromotionCampaignStrategyAdd());
    }

    public ContentPromotionCampaignStrategyAddMap(ContentPromotionCampaignStrategyAdd contentPromotionCampaignStrategyAdd) {
        super();
        setBean(contentPromotionCampaignStrategyAdd);
    }

    public ContentPromotionCampaignStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ContentPromotionCampaignStrategyAddMap withSearch(
            ContentPromotionCampaignSearchStrategyAddMap contentPromotionCampaignSearchStrategyAddMap)
    {
        ContentPromotionCampaignSearchStrategyAdd contentPromotionCampaignSearchStrategyAdd =
                ((contentPromotionCampaignSearchStrategyAddMap == null) ? null
                        : (ContentPromotionCampaignSearchStrategyAdd) (contentPromotionCampaignSearchStrategyAddMap.getBean()));
        this.put(SEARCH, contentPromotionCampaignSearchStrategyAdd);
        return this;
    }

    public ContentPromotionCampaignStrategyAddMap withNetwork(
            ContentPromotionCampaignNetworkStrategyAddMap contentPromotionCampaignNetworkStrategyAddMap)
    {
        ContentPromotionCampaignNetworkStrategyAdd contentPromotionCampaignNetworkStrategyAdd =
                ((contentPromotionCampaignNetworkStrategyAddMap == null) ? null
                        : (ContentPromotionCampaignNetworkStrategyAdd) (contentPromotionCampaignNetworkStrategyAddMap.getBean()));
        this.put(NETWORK, contentPromotionCampaignNetworkStrategyAdd);
        return this;
    }

    public ContentPromotionCampaignStrategyAddMap defaultContentPromotionCampaignStrategy() {
        return this
                .withSearch(new ContentPromotionCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                .withNetwork(new ContentPromotionCampaignNetworkStrategyAddMap()
                        .withBiddingStrategyType(ContentPromotionCampaignNetworkStrategyTypeEnum.SERVING_OFF));
    }
}
