package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignStrategy;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 17.11.15.
 */
public class ContentPromotionCampaignStrategyMap extends ModelBeanMap<ContentPromotionCampaignStrategyMap> {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";

    public ContentPromotionCampaignStrategyMap() {
        super();
        setBean(new ContentPromotionCampaignStrategy());
    }

    public ContentPromotionCampaignStrategyMap(ContentPromotionCampaignStrategy contentPromotionCampaignStrategy) {
        super();
        setBean(contentPromotionCampaignStrategy);
    }

    public ContentPromotionCampaignStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ContentPromotionCampaignStrategyMap withSearch(
            ContentPromotionCampaignSearchStrategyMap contentPromotionCampaignSearchStrategyMap)
    {
        ContentPromotionCampaignSearchStrategy contentPromotionCampaignSearchStrategy =
                ((contentPromotionCampaignSearchStrategyMap == null) ? null
                        : (ContentPromotionCampaignSearchStrategy) (contentPromotionCampaignSearchStrategyMap.getBean()));
        this.put(SEARCH, contentPromotionCampaignSearchStrategy);
        return this;
    }

    public ContentPromotionCampaignStrategyMap withNetwork(
            ContentPromotionCampaignNetworkStrategyMap contentPromotionCampaignNetworkStrategyMap)
    {
        ContentPromotionCampaignNetworkStrategy contentPromotionCampaignNetworkStrategy =
                ((contentPromotionCampaignNetworkStrategyMap == null) ? null
                        : (ContentPromotionCampaignNetworkStrategy) (contentPromotionCampaignNetworkStrategyMap.getBean()));
        this.put(NETWORK, contentPromotionCampaignNetworkStrategy);
        return this;
    }

    public ContentPromotionCampaignStrategyMap defaultContentPromotionCampaignStrategy() {
        return this
                .withSearch(new ContentPromotionCampaignSearchStrategyMap()
                        .withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                .withNetwork(new ContentPromotionCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(ContentPromotionCampaignNetworkStrategyTypeEnum.SERVING_OFF));
    }
}
