package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignStrategy;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignUpdateItem;
import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.PriorityGoalsUpdateSetting;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 17.11.15.
 */
public class ContentPromotionCampaignUpdateItemMap extends ContentPromotionCampaignBaseMap<ContentPromotionCampaignUpdateItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";

    public ContentPromotionCampaignUpdateItemMap() {
        super();
        setBean(new ContentPromotionCampaignUpdateItem());
    }

    public ContentPromotionCampaignUpdateItemMap(ContentPromotionCampaignUpdateItem contentPromotionCampaignUpdateItem) {
        super();
        setBean(contentPromotionCampaignUpdateItem);
    }

    public ContentPromotionCampaignUpdateItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ContentPromotionCampaignUpdateItemMap withBiddingStrategy(
            ContentPromotionCampaignStrategyMap contentPromotionCampaignStrategyMap)
    {
        ContentPromotionCampaignStrategy contentPromotionCampaignStrategy =
                ((contentPromotionCampaignStrategyMap == null) ? null
                        : (ContentPromotionCampaignStrategy) (contentPromotionCampaignStrategyMap.getBean()));
        this.put(BIDDING_STRATEGY, contentPromotionCampaignStrategy);
        return this;
    }

    public ContentPromotionCampaignUpdateItemMap withSettings(ContentPromotionCampaignSettingMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }
}
