package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignStrategy;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;

import static ch.lambdaj.Lambda.convert;

public class CpmBannerCampaignGetItemMap extends CpmBannerCampaignBaseMap<CpmBannerCampaignGetItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";

    public CpmBannerCampaignGetItemMap() {
        setBean(new CpmBannerCampaignGetItem());
    }

    public CpmBannerCampaignGetItemMap(CpmBannerCampaignGetItem cpmBannerCampaignGetItem) {
        super();
        setBean(cpmBannerCampaignGetItem);
    }

    public CpmBannerCampaignGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CpmBannerCampaignGetItemMap withBiddingStrategy(
            CpmBannerCampaignStrategyMap cpmBannerCampaignStrategyMap)
    {
        CpmBannerCampaignStrategy cpmBannerCampaignStrategy =
                ((cpmBannerCampaignStrategyMap == null) ? null
                        : (CpmBannerCampaignStrategy) (cpmBannerCampaignStrategyMap.getBean()));
        this.put(BIDDING_STRATEGY, cpmBannerCampaignStrategy);
        return this;
    }

    public CpmBannerCampaignGetItemMap withSettings(CpmBannerCampaignSettingGetMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public CpmBannerCampaignGetItemMap defaultCpmBannerCampaign() {
        return this.withBiddingStrategy(new CpmBannerCampaignStrategyMap().defaultCpmBannerCampaignStrategy());
    }
}
