package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.StrategyCpDecreasedPriceForRepeatedImpressionsAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyCpMaximumImpressionsAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyWbDecreasedPriceForRepeatedImpressionsAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyWbMaximumImpressionsAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by gerdler on 08.09.18.
 */
public class CpmBannerCampaignNetworkStrategyAddMap extends ModelBeanMap<CpmBannerCampaignNetworkStrategyAddMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";
    public static final String MAXIMUM_COVERAGE = "maximumCoverage";
    public static final String WB_MAXIMUM_IMPRESSIONS = "wbMaximumImpressions";
    public static final String CP_MAXIMUM_IMPRESSIONS = "cpMaximumImpressions";
    public static final String WB_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS = "wbDecreasedPriceForRepeatedImpressions";
    public static final String CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS = "cpDecreasedPriceForRepeatedImpressions";

    public CpmBannerCampaignNetworkStrategyAddMap() {
        super();
        setBean(new CpmBannerCampaignNetworkStrategyAdd());
    }

    public CpmBannerCampaignNetworkStrategyAddMap(
            CpmBannerCampaignNetworkStrategyAdd cpmBannerCampaignNetworkStrategyAdd)
    {
        super();
        setBean(cpmBannerCampaignNetworkStrategyAdd);
    }

    public CpmBannerCampaignNetworkStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap withBiddingStrategyType(
            CpmBannerCampaignNetworkStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap withWbMaximumImpressions(StrategyWbMaximumImpressionsAddMap paramsMap) {
        StrategyWbMaximumImpressionsAdd strategyMaximizeImpressionsWeekly =
                ((paramsMap == null) ? null : (StrategyWbMaximumImpressionsAdd) (paramsMap.getBean()));
        this.put(WB_MAXIMUM_IMPRESSIONS, strategyMaximizeImpressionsWeekly);
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap withCpMaximumImpressions(StrategyCpMaximumImpressionsAddMap paramsMap) {
        StrategyCpMaximumImpressionsAdd params =
                ((paramsMap == null) ? null : (StrategyCpMaximumImpressionsAdd) (paramsMap.getBean()));
        this.put(CP_MAXIMUM_IMPRESSIONS, params);
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap withWbDecreasedPriceForRepeatedImpressions(StrategyWbDecreasedPriceForRepeatedImpressionsAddMap paramsMap) {
        StrategyWbDecreasedPriceForRepeatedImpressionsAdd params =
                ((paramsMap == null) ? null : (StrategyWbDecreasedPriceForRepeatedImpressionsAdd) (paramsMap.getBean()));
        this.put(WB_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS, params);
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap withCpDecreasedPriceForRepeatedImpressions(StrategyCpDecreasedPriceForRepeatedImpressionsAddMap paramsMap) {
        StrategyCpDecreasedPriceForRepeatedImpressionsAdd params =
                ((paramsMap == null) ? null : (StrategyCpDecreasedPriceForRepeatedImpressionsAdd) (paramsMap.getBean()));
        this.put(CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS, params);
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap defaultStrategyWbMaximumImpressions(Currency currency) {
        return this.withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_IMPRESSIONS).withWbMaximumImpressions(
                new StrategyWbMaximumImpressionsAddMap().defaultStrategyWbMaximumImpressions(currency)
        );
    }
}
