package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaignsext.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.StrategyCpDecreasedPriceForRepeatedImpressions;
import com.yandex.direct.api.v5.campaignsext.StrategyCpMaximumImpressions;
import com.yandex.direct.api.v5.campaignsext.StrategyWbDecreasedPriceForRepeatedImpressions;
import com.yandex.direct.api.v5.campaignsext.StrategyWbMaximumImpressions;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by gerdler on 08.09.18.
 */
public class CpmBannerCampaignNetworkStrategyMap extends ModelBeanMap<CpmBannerCampaignNetworkStrategyMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";
    public static final String MAXIMUM_COVERAGE = "maximumCoverage";
    public static final String WB_MAXIMUM_IMPRESSIONS = "wbMaximumImpressions";
    public static final String CP_MAXIMUM_IMPRESSIONS = "cpMaximumImpressions";
    public static final String WB_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS = "wbDecreasedPriceForRepeatedImpressions";
    public static final String CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS = "cpDecreasedPriceForRepeatedImpressions";

    public CpmBannerCampaignNetworkStrategyMap() {
        super();
        setBean(new CpmBannerCampaignNetworkStrategy());
    }

    public CpmBannerCampaignNetworkStrategyMap(
            CpmBannerCampaignNetworkStrategy cpmBannerCampaignNetworkStrategy)
    {
        super();
        setBean(cpmBannerCampaignNetworkStrategy);
    }

    public CpmBannerCampaignNetworkStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CpmBannerCampaignNetworkStrategyMap withBiddingStrategyType(
            CpmBannerCampaignNetworkStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public CpmBannerCampaignNetworkStrategyMap withWbMaximumImpressions(StrategyWbMaximumImpressionsMap paramsMap) {
        StrategyWbMaximumImpressions strategyMaximizeImpressionsWeekly =
                ((paramsMap == null) ? null : (StrategyWbMaximumImpressions) (paramsMap.getBean()));
        this.put(WB_MAXIMUM_IMPRESSIONS, strategyMaximizeImpressionsWeekly);
        return this;
    }

    public CpmBannerCampaignNetworkStrategyMap withCpMaximumImpressions(StrategyCpMaximumImpressionsMap paramsMap) {
        StrategyCpMaximumImpressions params =
                ((paramsMap == null) ? null : (StrategyCpMaximumImpressions) (paramsMap.getBean()));
        this.put(CP_MAXIMUM_IMPRESSIONS, params);
        return this;
    }

    public CpmBannerCampaignNetworkStrategyMap withWbDecreasedPriceForRepeatedImpressions(StrategyWbDecreasedPriceForRepeatedImpressionsMap paramsMap) {
        StrategyWbDecreasedPriceForRepeatedImpressions params =
                ((paramsMap == null) ? null : (StrategyWbDecreasedPriceForRepeatedImpressions) (paramsMap.getBean()));
        this.put(WB_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS, params);
        return this;
    }

    public CpmBannerCampaignNetworkStrategyMap withCpDecreasedPriceForRepeatedImpressions(StrategyCpDecreasedPriceForRepeatedImpressionsMap paramsMap) {
        StrategyCpDecreasedPriceForRepeatedImpressions params =
                ((paramsMap == null) ? null : (StrategyCpDecreasedPriceForRepeatedImpressions) (paramsMap.getBean()));
        this.put(CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS, params);
        return this;
    }
}
